local function GetPlScore(pl, scoretype)
	local primary_score = STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetScore()
	local secondary_score = FormatPercentScore(STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetPercentDancePoints())

	if PREFSMAN:GetPreference("PercentageScoring") then
		primary_score, secondary_score = secondary_score, primary_score
	end

	if scoretype == "primary" then
		return primary_score
	else
		return secondary_score
	end
end

local t = Def.ActorFrame {};

t[#t+1] = Def.Quad {
	Texture="_frame";
	InitCommand=function(self)
		self:horizalign(center):vertalign(top):x(SCREEN_CENTER_X):y(SCREEN_TOP)
		self:zoomto(SCREEN_WIDTH,100):diffuse(color("#000000"))
	end;
	OnCommand=function(self)
		self:fadebottom(1.0):diffusealpha(0.75)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
};

t[#t+1] = Def.Sprite {
	Texture="_frame";
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+30)
	end;
	OnCommand=function(self)
		self:addy(-260):decelerate(0.6):addy(260)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
};

t[#t+1] = Def.Sprite {
	Texture="_glow";
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+30)
	end;
	OnCommand=function(self)
		self:addy(-260):decelerate(0.6):addy(260)
		self:diffuseramp():effectclock("beatnooffset"):effectcolor1(1,1,1,1):effectcolor2(1,1,1,0.3)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
};

--- Song info
t[#t+1] = LoadFont("Common Normal") .. {
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+18):zoom(0.5):maxwidth(420/0.5):diffuse(color("#75DCDB")):diffusetopedge(color("#92F5E7")):horizalign(center)
	end;
	OnCommand=function(self)
		self:addy(-260):decelerate(0.6):addy(260)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
	CurrentSongChangedMessageCommand=function(self)
		   local song = GAMESTATE:GetCurrentSong();
		   if song then
				self:settext(song:GetDisplayFullTitle());
				self:playcommand("Refresh");
			else
				self:settext("");
				self:playcommand("Refresh");
		   end
	  end;
};

for ip, pn in ipairs(GAMESTATE:GetEnabledPlayers()) do
		local score_x_position = string.find(pn, "P1") and SCREEN_CENTER_X-280 or SCREEN_CENTER_X+280;
		local score_align = string.find(pn, "P1") and left or right;
		local vStats = STATSMAN:GetCurStageStats():GetPlayerStageStats( pn );
		
		t[#t+1] = Def.ActorFrame {
		OnCommand=function(self)
			self:addy(-260):decelerate(0.6):addy(260)
		end;
		OffCommand=function(self)
			self:sleep(1.4):decelerate(3):addy(-260)
		end;
			Def.BitmapText {
				Font="Common Normal",
				InitCommand=function(self)
					self:xy(score_x_position,SCREEN_TOP+35)
					self:diffuse(color("#92F5E7")):horizalign(score_align):maxwidth(150):zoom(0.75)
					if PREFSMAN:GetPreference("PercentageScoring") then
						self:settext("0.00%")
					else
						self:settext("0")
					end
				end,
				OnCommand=function(self)
					if GAMESTATE:GetPlayMode() == "PlayMode_Endless" then
						self:queuecommand("UpdateTimer")
					end
				end;
				JudgmentMessageCommand=function(self)
					if GAMESTATE:GetPlayMode() == "PlayMode_Endless" then
						self:queuecommand("UpdateTimer")
					else
						self:queuecommand("RedrawScore")
					end
				end,
				UpdateTimerCommand=function(self)
					self:finishtweening():settext( SecondsToMMSSMsMs( vStats:GetAliveSeconds() ) )
					:sleep(1/60):queuecommand("UpdateTimer")
				end;
				RedrawScoreCommand=function(self)
					self:settext(GetPlScore(pn, "primary"))
				end;
			};
			
			LoadFont("Common normal") .. { 
				InitCommand=function(self)
					self:xy(score_x_position,SCREEN_TOP+19):zoom(0.4):horizalign(score_align):diffuse(color("#FFFFFF")):maxwidth(100) 
				end;
				OnCommand=function(self)
					self:playcommand("Set")
				end;
				["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:playcommand("Set") end;
				SetCommand=function(self)
						local steps_data = GAMESTATE:GetCurrentSteps(pn)
						local song = GAMESTATE:GetCurrentSong();
							if song then
								if steps_data ~= nil then
								local st = steps_data:GetStepsType();
								local diff = steps_data:GetDifficulty();
								local cd = GetCustomDifficulty(st, diff);
								self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)) .. " " .. steps_data:GetMeter())
								self:diffuse(BoostColor(ColorLightTone(CustomDifficultyToColor(cd)),1.3));
							end
						end
				end;
			};
		};
	end;
	t[#t+1] = LoadActor("bpmDisplay.lua");
	
return t;